﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace MicroRWD.QT
{
    #region EventArgs

    // Status update event arguments
    public class StatusUpdateEventArgs : EventArgs
    {
        #region Public Properties

        // The latest status
        public Status Status { get; set; }

        #endregion


        #region Constructor

        // Constructs  anew status update event arguments instance
        public StatusUpdateEventArgs(Status _status)
        {
            Status = _status;
        }

        #endregion
    }

    #endregion


    #region Delegates

    // Delegate to handle despatch of status update events
    public delegate void StatusUpdateEventHandler(object sender, StatusUpdateEventArgs args);

    #endregion
}
